<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class WorkDay extends Model 
{

    protected $table = 'work_days';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('from', 'to', 'day', 'doctor_id');

    public function doctor()
    {
        return $this->belongsTo('App\Models\Doctor');
    }

}